// GPTestView.cpp : implementation of the CGPTestView class
//

#include "stdafx.h"
#include "GPTest.h"

#include "GPTestDoc.h"
#include "GPTestView.h"

#import "C:\\Temp\\GoldParser\\GOLD Parser Engine.dll" no_namespace

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGPTestView

IMPLEMENT_DYNCREATE(CGPTestView, CFormView)

BEGIN_MESSAGE_MAP(CGPTestView, CFormView)
	//{{AFX_MSG_MAP(CGPTestView)
	ON_BN_CLICKED(IDC_BUTTON1, OnButton1)
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CFormView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CFormView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CFormView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGPTestView construction/destruction

CGPTestView::CGPTestView()
	: CFormView(CGPTestView::IDD)
{
	//{{AFX_DATA_INIT(CGPTestView)
	m_sSql = _T("select mycolumn from mytable where mycolumn = 'abc123'");
	//}}AFX_DATA_INIT
	// TODO: add construction code here

}

CGPTestView::~CGPTestView()
{
}

void CGPTestView::DoDataExchange(CDataExchange* pDX)
{
	CFormView::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGPTestView)
	DDX_Control(pDX, IDC_LIST1, m_list);
	DDX_Text(pDX, IDC_EDIT1, m_sSql);
	//}}AFX_DATA_MAP
}

BOOL CGPTestView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CFormView::PreCreateWindow(cs);
}

void CGPTestView::OnInitialUpdate()
{
	CFormView::OnInitialUpdate();
	GetParentFrame()->RecalcLayout();
	ResizeParentToFit();

}

/////////////////////////////////////////////////////////////////////////////
// CGPTestView printing

BOOL CGPTestView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CGPTestView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CGPTestView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

void CGPTestView::OnPrint(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add customized printing code here
}

/////////////////////////////////////////////////////////////////////////////
// CGPTestView diagnostics

#ifdef _DEBUG
void CGPTestView::AssertValid() const
{
	CFormView::AssertValid();
}

void CGPTestView::Dump(CDumpContext& dc) const
{
	CFormView::Dump(dc);
}

CGPTestDoc* CGPTestView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CGPTestDoc)));
	return (CGPTestDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CGPTestView message handlers


// See http://www.devincook.com/GOLDParser/doc/engine/activex/engine-overview.htm
// and http://www.devincook.com/GOLDParser/doc/builder/
#include <atlbase.h>											// CComBstr
void CGPTestView::OnButton1()
{
	UpdateData(true);
	m_list.ResetContent();

	try {

		// Be sure open a DOS box and say:  REGSVR32 "GOLD Parser Engine.dll"
		CoInitialize(NULL);
		_GOLDParserPtr Parser(__uuidof(GOLDParser));

		CComBSTR bstr;
		bstr = "SQL-ANSI-89.cgt";

		Parser->LoadCompiledGrammar(&bstr.m_str);	// Note that this is implemented incorrectly - always returns false.

		bstr = m_sSql;
		VERIFY(Parser->OpenTextString(&bstr.m_str));

		// Parse.
		bool bDone(false);

		while (! bDone) {

			GPMessageConstants eResponse(
			  static_cast<GPMessageConstants> (Parser->Parse()));

			switch (eResponse) {

				// Place code here to handle a illegal or unrecognized token.
				// To recover, pop the token from the stack: Parser->PopInputToken.
				case gpMsgLexicalError:
					_ASSERTE(! "gpMsgLexicalError");
					TRACE("gpMsgLexicalError\n");
					//Parser->PopInputToken.
					bDone = true;
					break;

				// This is a syntax error: the source has produced a token that
				// was not expected by the LALR State Machine. The expected
				// tokens are stored into the Tokens() list. To recover, push
				// one of the expected tokens onto the parser's input queue (the
				// first in this case).  You should limit the number of times
				// this type of recovery can take place.
				case gpMsgSyntaxError:
					_ASSERTE(! "gpMsgSyntaxError");
					TRACE("gpMsgSyntaxError\n");
					//Parser->PushInputToken(Parser->Tokens(0));
					bDone = true;
					break;

				// This message is returned when a rule was reduced by the parse
				// engine.  The CurrentReduction property is assigned a Reduction
				// object containing the rule and its related tokens. You can
				// reassign this property to your own customized class. If this
				// is not the case, this message can be ignored and the Reduction
				// object will be used to store the parse tree.
				case gpMsgReduction:
					TRACE("gpMsgReduction\n");

					//switch(Parser->CurrentReduction.ParentRule.TableIndex) {
					//	;
					//}

					// Parser->CurrentReduction = //Object you created to store the rule
					break;

				// The program was accepted by the parsing engine.  In other
				// words, we're done.
				case gpMsgAccept:
					TRACE("gpMsgAccept\n");
					bDone = true;
					break;

				// The end of the input was reached while reading a comment.
				// This is caused by a comment that was not terminated.
				case gpMsgCommentError:
					_ASSERTE(! "gpMsgCommentError");
					TRACE("gpMsgCommentError\n");
					break;

				// A token was read by the parser. The Token Object can be
				// accessed through the CurrentToken() property Parser->CurrentToken.
				case gpMsgTokenRead:
					{
					TRACE("gpMsgTokenRead\n");
					_TokenPtr Token(Parser->CurrentToken());
					_bstr_t bstrText(Token->GetText());
					CString sText((const char *) bstrText);
					m_list.AddString(sText);
					break;
					}

				// Something horrid happened inside the parser. You can't recover.
				case gpMsgInternalError:
					_ASSERTE(! "gpMsgInternalError");
					TRACE("gpMsgInternalError\n");
					bDone = true;
					break;

				// Load the Compiled Grammar Table file first.
				case gpMsgNotLoadedError:
					_ASSERTE(! "gpMsgNotLoadedError");
					TRACE("gpMsgNotLoadedError\n");
					bDone = true;
					break;

				// Oops.
				default:
					_ASSERTE(! "Illegal default case!");
					TRACE("Illegal default case\n");
					break;
			}
		}
	}
	catch(_com_error &e) {
		_ASSERTE(! "_com_error exception");
		HRESULT hr(e.WCodeToHRESULT(e.WCode()));
		if (SUCCEEDED(hr)) hr = e.Error();
		if (SUCCEEDED(hr)) hr = E_FAIL;

		_bstr_t bstrSource(e.Source());
		_bstr_t bstrDescription(e.Description());

		TRACE ("COM Error: Code <%x>\n", e.Error());
		TRACE ("   Code meaning <%s>\n", e.ErrorMessage());
		TRACE ("   Source <%s>\n", (LPCSTR) bstrSource);

		// For some reason they sometimes append a CR for us.
		CString sDescription((LPCSTR) bstrDescription);
		sDescription.TrimRight();
		TRACE ("   Description <%s>\n", sDescription);
	}

	CoUninitialize();
}
